<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Proveedor;
use App\Models\TipoDocumento;

class ProveedorController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth:usuario');
    }

    public function nuevo()
    {
	 	return view('proveedor.nuevo', [ 'tipo_documento' => TipoDocumento::all() ]); 
	}

	public function listar()
    {
	 	$res = Proveedor::where('estado', 1)->orderBy('created_at', 'desc')->paginate(20);
        return view('proveedor.listar', [ 'data' => $res]); 
	}

    public function existeCampo(Request $request)
    {
        if ($request->ajax())
        {    
            $val = 0;
            if ($request->valor != '') {
                $val = Proveedor::where($request->campo, '=', $request->valor)->count();
            }
            
            return response()->json($val); 
        }
    }

	public function registrar(Request $request)
    {
        if ($request->ajax())
        {    
            $res = Proveedor::create($request->all());
            
            $res ? $res['message'] = 'success' : $res['message'] = 'error';

            return response()->json($res); 
        }
	}

    public function editar($id)
    {
        return view('proveedor.editar', [
            'data' => Proveedor::where(['id_proveedor' => $id , 'estado' => 1])->first(), 
            'tipo_documento' => TipoDocumento::all() 
        ]); 
    }

    public function actualizar(Request $request)
    {
        if ($request->ajax())
        {
            $data = Proveedor::find($request->id_proveedor);

            $data->nombre             	= $request->nombre; 
            $data->id_tipo_documento 	= $request->id_tipo_documento;
            $data->numero_documento 	= $request->numero_documento;
            $data->direccion          	= $request->direccion;
            $data->telefono           	= $request->telefono;
            $data->email                = $request->email;

            $res  = $data->save();

            return response()->json($res ? ['message' => 'success'] : ['message' => 'error']);  
        }
    }

    public function eliminar(Request $request)
    {
    	if ($request->ajax())
        {
	      	$data = Proveedor::find($request->id_proveedor);
            $data->estado = 0;
            $res  = $data->save();
	    
	        return response()->json($res ? ['message' => 'success'] : ['message' => 'error']);  
    	}
    }

    public function getById(Request $request)
    {
        if ($request->ajax())
        {
            $res = Proveedor::with(['tipo_documento'])->find($request->id_proveedor);
            return response()->json($res);  
        }
    }

    public function buscar(Request $request)
    {
        if ($request)
        {
            $id = TipoDocumento::where('nombre', 'LIKE', '%'.$request->search.'%')->first();

            $res =  Proveedor::with(['tipo_documento'])->where(function ($query) {
                        $query->where('estado', '=', 1);
                    })->where(function ($query)  use ($request, $id) {
                        $query->where('nombre', 'LIKE',  '%'.$request->search.'%')
                              ->orWhere('numero_documento', 'LIKE',  '%'.$request->search.'%')
                              ->orWhere('direccion', 'LIKE',  '%'.$request->search.'%')
                              ->orWhere('telefono', 'LIKE', '%'.$request->search.'%')
                              ->orWhere('email', 'LIKE', '%'.$request->search.'%')
                              ->orWhere('id_tipo_documento', '=', $id ? $id->id_tipo_documento : '');
                    })->paginate(10);
                    
            $res->appends(['search' => $request->search]);         
            return view('proveedor.listar', ['data' => $res]); 
        }
    }

}
